<?php 
include 'header1.php'; 
include 'koneksi.php';

if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];

    // Pastikan ID yang dihapus adalah angka
    if (!empty($id) && is_numeric($id)) {
        $query = "DELETE FROM mahasiswa WHERE id = ?";
        $stmt = $conn->prepare($query);

        if ($stmt) {
            $stmt->bind_param("i", $id);
            if ($stmt->execute()) {
                echo "<script>
                    alert('Data berhasil dihapus!');
                    window.location = 'mahasiswa.php';
                </script>";
            } else {
                echo "<script>alert('Gagal menghapus data!');</script>";
            }
            $stmt->close();
        }
    }
}

// Ambil data mahasiswa dari tabel mahasiswa
$mahasiswa = query("SELECT * FROM mahasiswa ORDER BY id");
?>


<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-4 bg-light rounded" style="font-size: 28px;">
                <strong>DATA ALTERNATIF</strong></h2>

            <div class="card shadow-lg w-100">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <span style="font-size: 20px;"><i class="fas fa-users"></i> Daftar Mahasiswa</span>
                    <a href="tambah_mahasiswa.php" class="btn btn-light btn-sm">
                        <i class="fas fa-plus"></i> Tambah Data Mahasiswa
                    </a>
                </div>

                <div class="table-responsive">
                    <table id="datatablesSimple" class="table table-striped table-bordered table-hover w-100" style="font-size: 20px;">
                        <thead class="table-primary text-center align-middle">
                            <tr style="height: 50px;">
                                <th style="width: 5%;">No.</th>
                                <th style="width: 18%;">Nama Alternatif</th>
                                <th style="width: 21%;">Nama Mahasiswa</th>
                                <th style="width: 15%;">NIM</th>
                                <th style="width: 20%;">E-mail</th>
                                <th style="width: 8%">Aksi</th>
                            </tr>
                        </thead>                        
                        <tbody class="text-center">
                            <?php $i = 1; ?>
                            <?php foreach ($mahasiswa as $row) : ?>    
                                <tr style="height: 55px;">
                                    <td class="align-middle"><?= $i ?></td>
                                    <td class="align-middle text-center"><?= htmlspecialchars($row["alternatif"]); ?></td>
                                    <td class="align-middle text-center"><?= htmlspecialchars($row["nama"]); ?></td>
                                    <td class="align-middle text-center"><?= htmlspecialchars($row["nim"]); ?></td>
                                    <td class="align-middle text-center"><?= htmlspecialchars($row["email"]); ?></td>
                                    <td class="align-middle text-center">
                                        <div class="d-flex justify-content-center gap-2">
                                            <a href="ubah_mahasiswa.php?id=<?= $row["id"]; ?>" class="btn btn-warning btn-sm">
                                                <i class="fas fa-edit"></i> Ubah
                                            </a>
                                            <a href="mahasiswa.php?hapus=<?= $row["id"]; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus?');">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php $i++ ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>
</div>

<!-- Pastikan navigasi bisa dibuka dan tidak macet -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>
